**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
*01 By grouping
*02 test of difference
*03 Robustness - most versus rest


**** importing financial dependence metric as per Demmou et al
clear 
import excel "${data}\Rajan zingales - Demmou et al.xlsx", sheet("stata") firstrow 


rename ANZ industry

xtile quartfindep=FINDEPRZ, n (4)

destring industry, replace

save findep.dta, replace

**** merging the metric with the baseline sample
merge 1:m industry using bas_final.dta

keep if _m==3
drop _m

tsset firmid2 period
  
***01 By grouping

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if quartfindep==4 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_basqr4.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if quartfindep==4 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_basqr4.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if quartfindep==1 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_basqr1.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if quartfindep==1 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_basqr1.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if quartfindep==3 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_basqr3.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if quartfindep==3 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_basqr3.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if quartfindep==2 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_basqr2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if quartfindep==2 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_basqr2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



***02 test of difference
*** testing whether quartiles differ between each other

*/
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' i.quartfindep##(l(0/1).c.beckers_aug l(1/1).c.intmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) if quartfindep==4 |  quartfindep==1, cluster (period firmid2) a(i.quartfindep##i.fsize_ i.quartfindep##i.ind i.quartfindep##i.qr)
}

estout * using "${results}\test_findep_int.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' i.quartfindep##(l(0/1).c.beckers_aug l(1/1).c.extmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) if quartfindep==4 |  quartfindep==1 , cluster (period firmid2) a(i.quartfindep##i.fsize_ i.quartfindep##i.ind i.quartfindep##i.qr)
}


estout * using "${results}\test_findep_ext.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



*********03 Robustness - most versus rest
*** top refers to the highest quartile - most dependent firms
gen top=(quartfindep==4)

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if top==1 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_basqr4_not_top.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if top=1 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_basqr4_not_top.csv", replace	ci stats(r2 N)



eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if top==0 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_basqr4_not_top.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.fsize_ i.qr if top=0 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_basqr4_not_top.csv", replace	ci stats(r2 N)



